import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';
import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';

import {deviceMods} from 'utilities/stylesUtils';

import Separator from 'components/Separator/Separator';
import TrainsSearchVariantTransfer from '../TrainsSearchVariantTransfers/components/TrainsSearchVariantTransfer';

import cx from './TrainsSearchVariantTransferSeparator.scss';

interface ITrainsSearchVariantTransferSeparatorProps
    extends IWithDeviceType,
        IWithClassName {
    currentSegment: ITrainsSegment;
    nextSegment: ITrainsSegment;
}

const TrainsSearchVariantTransferSeparator: React.FC<ITrainsSearchVariantTransferSeparatorProps> =
    ({currentSegment, nextSegment, deviceType, className}) => {
        return (
            <div
                className={cx(
                    'root',
                    deviceMods('root', deviceType),
                    className,
                )}
            >
                <TrainsSearchVariantTransfer
                    deviceType={deviceType}
                    currentSegment={currentSegment}
                    nextSegment={nextSegment}
                />
                {deviceType.isDesktop && (
                    <Separator className={cx('separator')} />
                )}
            </div>
        );
    };

export default TrainsSearchVariantTransferSeparator;
