import React from 'react';

import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TrainsSearchVariantTransfer from './components/TrainsSearchVariantTransfer';

interface ITrainsSearchVariantTransfersProps
    extends IWithClassName,
        IWithQaAttributes,
        IWithDeviceType {
    variant: ITrainsVariant;
}

const TrainsSearchVariantTransfers: React.FC<ITrainsSearchVariantTransfersProps> =
    props => {
        const {
            variant: {forward},
            deviceType,
            className,
        } = props;

        return (
            <div
                className={className}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'transfers',
                })}
            >
                {forward.map((currentSegment, index) => {
                    const nextSegment = forward[index + 1];

                    if (index < forward.length - 1) {
                        return (
                            <TrainsSearchVariantTransfer
                                key={currentSegment.id}
                                currentSegment={currentSegment}
                                nextSegment={nextSegment}
                                deviceType={deviceType}
                            />
                        );
                    }

                    return null;
                })}
            </div>
        );
    };

export default TrainsSearchVariantTransfers;
