import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';

import {deviceMods} from 'utilities/stylesUtils';
import {getTrainsTransferHumanDurationBySegments} from 'projects/trains/lib/genericSearch/transfers/getTrainsTransferHumanDurationBySegments';
import {getTrainsTransferTypeAndDescriptionBySegments} from 'projects/trains/lib/genericSearch/transfers/getTrainsTransferTypeAndDescriptionBySegments';

import ConnectionIcon from 'icons/12/Connection';

import cx from './TrainsSearchVariantTransfer.scss';

interface ITrainsSearchVariantTransferProps extends IWithDeviceType {
    currentSegment: ITrainsSegment;
    nextSegment: ITrainsSegment;
}

const TrainsSearchVariantTransfer: React.FC<ITrainsSearchVariantTransferProps> =
    props => {
        const {currentSegment, nextSegment, deviceType} = props;
        const {description, isStationChanged} =
            getTrainsTransferTypeAndDescriptionBySegments({
                currentSegment,
                nextSegment,
            });

        return (
            <div className={cx('root', deviceMods('root', deviceType))}>
                <div className={cx('content')}>
                    {isStationChanged && (
                        <ConnectionIcon className={cx('changeIcon')} />
                    )}
                    <span className={cx('point')}>{description}</span>
                    <span className={cx('duration')}>
                        {getTrainsTransferHumanDurationBySegments({
                            currentSegment,
                            nextSegment,
                        })}
                    </span>
                </div>
            </div>
        );
    };

export default TrainsSearchVariantTransfer;
