import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceModMobile} from 'utilities/stylesUtils';

import cx from './TrainsSearchVariantsDateSeparator.scss';

interface ITrainsSearchVariantsDateSeparatorProps
    extends IWithDeviceType,
        IWithQaAttributes {
    date: string;
}

const TrainsSearchVariantsDateSeparator: React.FC<ITrainsSearchVariantsDateSeparatorProps> =
    props => {
        const {date, deviceType} = props;

        return (
            <div className={cx('root', deviceModMobile('root', deviceType))}>
                <span className={cx('date')} {...prepareQaAttributes(props)}>
                    {date}
                </span>
            </div>
        );
    };

export default TrainsSearchVariantsDateSeparator;
