import {MutableRefObject, useEffect, useMemo, useRef} from 'react';

import {TTrainsVariantId} from 'types/trains/common/variant/ITrainsVariant';

import {usePrevious} from 'utilities/hooks/usePrevious';

const STATIC_ADFOX_BANNER_KEY = 'trainsSearchAdFoxBanner';

/**
 * Проблема: при перерисовке ноды баннера срабатывает (это предположение) какой-то код внутри adfox,
 * который прячет содержимое.
 *
 * Если ноды перед баннером не перерисовываются (т.е. variantIds остаются прежними),
 * то не будет перерисовываться и баннер.
 *
 * @see https://st.yandex-team.ru/TRAVELFRONT-6106
 */
export default function useAdfoxBannerKeyRef(
    variantIds: TTrainsVariantId[],
    bannerIndexPosition: number,
): MutableRefObject<string> {
    const keyRef = useRef<string>(STATIC_ADFOX_BANNER_KEY);

    const beforeBannerVariantsKey = useMemo(() => {
        return variantIds.slice(0, bannerIndexPosition - 1).join('.');
    }, [bannerIndexPosition, variantIds]);

    const prevBeforeBannerVariantsKey = usePrevious(beforeBannerVariantsKey);

    useEffect(() => {
        if (beforeBannerVariantsKey !== prevBeforeBannerVariantsKey) {
            keyRef.current = String(Math.random());
        }
    }, [beforeBannerVariantsKey, prevBeforeBannerVariantsKey]);

    return keyRef;
}
