import {TTrainsVariantId} from 'types/trains/common/variant/ITrainsVariant';

export enum ESearchListItemType {
    BANNER = 'BANNER',
    VARIANT = 'VARIANT',
    DAY_SEPARATOR = 'DAY_SEPARATOR',
    SUBSCRIPTION_FORM = 'SUBSCRIPTION_FORM',
    HOTELS_CROSS_SALE = 'HOTELS_CROSS_SALE',
}

export type TSearchListItem =
    | {
          type: ESearchListItemType.VARIANT;
          variantId: TTrainsVariantId;
      }
    | {
          type: ESearchListItemType.DAY_SEPARATOR;
          date: string;
      }
    | {
          type:
              | ESearchListItemType.BANNER
              | ESearchListItemType.SUBSCRIPTION_FORM;
      }
    | {
          type: ESearchListItemType.HOTELS_CROSS_SALE;
      };
