import {Moment} from 'moment-timezone';

import {ITrainsVariantAndDirection} from 'types/trains/common/variant/ITrainsVariant';

import {getTrainsVariantLocalDepartureTime} from 'projects/trains/lib/genericSearch/variants/getTrainsVariantDeparture';

export default function getNextDaySeparatorInfo({
    variantAndDirection,
    separatorMoment,
    isReverseSorting,
    isFirstVisibleSegment,
}: {
    variantAndDirection: ITrainsVariantAndDirection;
    separatorMoment: Moment;
    isReverseSorting: boolean;
    isFirstVisibleSegment: boolean;
}): {
    needToAdd: boolean;
    needToCheckFurther: boolean;
} {
    const segmentDeparture =
        getTrainsVariantLocalDepartureTime(variantAndDirection);

    if (!segmentDeparture) {
        return {
            needToAdd: false,
            needToCheckFurther: false,
        };
    }

    if (isFirstVisibleSegment) {
        return {
            needToAdd: false,
            needToCheckFurther: isReverseSorting
                ? segmentDeparture.isAfter(separatorMoment)
                : segmentDeparture.isBefore(separatorMoment),
        };
    }

    const needToAdd = isReverseSorting
        ? segmentDeparture.isBefore(separatorMoment)
        : segmentDeparture.isAfter(separatorMoment);

    return {
        needToAdd,
        needToCheckFurther: !needToAdd,
    };
}
