import {
    ESearchListItemType,
    TSearchListItem,
} from 'projects/trains/components/TrainsSearchVariants/types/ITrainsSearchVariants';

export default function getVisibleItems(
    items: TSearchListItem[],
    count: number,
): TSearchListItem[] {
    const visibleItems: TSearchListItem[] = [];
    let accVisibleItemsCount = 0;

    for (const item of items) {
        visibleItems.push(item);

        if (item.type !== ESearchListItemType.DAY_SEPARATOR) {
            accVisibleItemsCount++;
        }

        if (accVisibleItemsCount === count) {
            return visibleItems;
        }
    }

    return visibleItems;
}
