import React from 'react';

import * as i18nBlock from 'i18n/trains-UpdateNotification';

import BaseUpdateNotification, {
    IUpdateNotificationProps,
} from 'components/UpdateNotification/UpdateNotification';

const UpdateNotification: React.FC<
    Pick<
        IUpdateNotificationProps,
        | 'onUpdate'
        | 'primaryActionText'
        | 'timeout'
        | 'text'
        | 'onShowNotification'
        | 'canReloadPageAfterAction'
        | 'onSkip'
    >
> = ({text = i18nBlock.text(), ...props}) => {
    return <BaseUpdateNotification text={text} {...props} />;
};

export default UpdateNotification;
