import React from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {EBadgeTheme} from 'projects/trains/components/badges/Badge/types';

import Link from 'components/Link/Link';
import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';

import Badge from './Badge';

export default {
    title: 'Trains/Badge',
    component: Badge,
} as Meta;

export const BadgeWithLink: TStorybookFunctionComponent = () => {
    const hint: React.ReactNode = (
        <Link
            text="Это хинт в виде brand ссылки"
            theme="brand"
            url="https://ya.ru"
            target="_blank"
        />
    );

    return <Badge hint={hint}>Hover Me</Badge>;
};

export const BadgeThemes: TStorybookFunctionComponent = () => {
    const hint: React.ReactNode = (
        <Link
            text="Это хинт в виде brand ссылки"
            theme="brand"
            url="https://ya.ru"
            target="_blank"
        />
    );

    return (
        <Box between="2">
            <Heading level="3">Light</Heading>
            <Box between="5" inline>
                <Badge hint={hint} theme={EBadgeTheme.LIGHT}>
                    Hover Me
                </Badge>
            </Box>
            <Heading level="3">White</Heading>
            <Box between="5" inline>
                <Badge hint={hint} theme={EBadgeTheme.WHITE}>
                    Hover Me
                </Badge>
            </Box>
            <Heading level="3">Dark</Heading>
            <Box between="5" inline>
                <Badge hint={hint} theme={EBadgeTheme.DARK}>
                    Hover Me
                </Badge>
            </Box>
            <Heading level="3">Blue</Heading>
            <Box between="5" inline>
                <Badge hint={hint} theme={EBadgeTheme.BLUE}>
                    Hover Me
                </Badge>
            </Box>
            <Heading level="3">Yellow</Heading>
            <Box between="5" inline>
                <Badge hint={hint} theme={EBadgeTheme.YELLOW}>
                    Hover Me
                </Badge>
            </Box>
        </Box>
    );
};
