import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {EBadgeTheme} from 'projects/trains/components/badges/Badge/types';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/trains-segment';

import Badge from 'projects/trains/components/badges/Badge/Badge';
import Link from 'components/Link/Link';

const LINK = 'https://yandex.ru/support/travel/trains/price.html#factors';

interface IDynamicPricingProps extends IWithClassName {
    theme?: EBadgeTheme;
}

const DynamicPricing: React.FC<IDynamicPricingProps> = props => {
    const {className, theme} = props;

    const hint = insertJSXIntoKey(
        i18nBlock.segmentDashDynamicDashPricingDashHint,
    )({
        link: (
            <Link
                key="link"
                url={LINK}
                target="_blank"
                rel="noopener noreferrer"
            >
                {i18nBlock.segmentDashDynamicDashPricingDashHintDashLink()}
            </Link>
        ),
    });

    return (
        <Badge className={className} hint={hint} theme={theme}>
            {i18nBlock.dynamicDashPricing()}
        </Badge>
    );
};

export default React.memo(DynamicPricing);
