import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {EBadgeTheme} from 'projects/trains/components/badges/Badge/types';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/trains-segment';

import Badge from 'projects/trains/components/badges/Badge/Badge';

interface IETicketProps extends IWithClassName, IWithQaAttributes {
    theme?: EBadgeTheme;
}

const ETicket: React.FC<IETicketProps> = props => {
    const {className, theme} = props;

    return (
        <Badge
            className={className}
            hint={i18nBlock.eDashTicketDashHint()}
            theme={theme}
            {...prepareQaAttributes({
                parent: props,
                current: 'electronicRegistration',
            })}
        >
            {i18nBlock.eDashTicket()}
        </Badge>
    );
};

export default React.memo(ETicket);
