import React, {ReactNode, useEffect, useMemo} from 'react';

import {IOS_OS_NAME, EProjectName} from 'constants/common';

import {EFooterProject} from 'components/Footer/types';

import {IDevice} from 'reducers/common/commonReducerTypes';

import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';

import cx from './styles.scss';

interface IOwnProps {
    children: null | {
        left?: ReactNode;
        right?: ReactNode;
        footer?: ReactNode;
        allWidth?: ReactNode;
    };
    deviceType: IDevice;
}

const TrainsOrderLayout: React.FC<IOwnProps> = ({deviceType, children}) => {
    const footerRef = React.createRef<HTMLDivElement>();

    // WAT?
    // @see https://st.yandex-team.ru/TRAVELFRONT-1975
    // Почему-то в iOS 10 и меньше при переходе на страницу не отображается блок с футером,
    // хотя содержимое в dom-элементе есть.
    // Поэтому используем грязный хак, чтобы произошел перерендер.
    useEffect(() => {
        if (
            deviceType.os.name === IOS_OS_NAME &&
            Number(deviceType.os.version.split('.')[0]) <= 10
        ) {
            setTimeout(() => {
                if (footerRef.current) {
                    const defaultValue = footerRef.current.style.display;

                    footerRef.current.style.display = 'none';
                    footerRef.current.style.display = defaultValue;
                }
            }, 0);
        }
    });

    const content = useMemo(() => {
        if (!children) {
            return null;
        }

        if (children.allWidth) {
            return (
                <div className={cx('content', 'content_align_center')}>
                    {children.allWidth}
                </div>
            );
        }

        return (
            <>
                <div className={cx('content')}>
                    <div className={cx('column', 'column_left')}>
                        {children.left}
                    </div>

                    <div className={cx('column', 'column_right')}>
                        {children.right}
                    </div>
                </div>

                <div ref={footerRef} className={cx('footer')}>
                    {children.footer}
                </div>
            </>
        );
    }, [children, footerRef]);

    return (
        <LayoutDefault
            isFixedNavigation
            showSearchForm={deviceType.isDesktop}
            showNavigation={deviceType.isDesktop}
            searchFormInitialIsExpanded={false}
            project={EProjectName.TRAINS}
            footerType={EFooterProject.TRAINS}
        >
            <div
                className={cx('root', {
                    root_mobile: deviceType.isMobile,
                    root_desktop: deviceType.isDesktop,
                })}
            >
                {content}
            </div>
        </LayoutDefault>
    );
};

export default TrainsOrderLayout;
