import React from 'react';
import {useLocation} from 'react-router-dom';
import {useSelector} from 'react-redux';

import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import {orderStepSelector} from 'selectors/trains/order/orderStepSelector';
import trainListSelector from 'selectors/trains/order/trainListSelector';

import {getAbsoluteUrl} from 'utilities/url';
import getTitle from 'projects/trains/components/meta/TrainsOrderMeta/utilities/getTitle';
import getTrainNumber from 'projects/trains/lib/order/getTrainNumber';

import * as i18nBlock from 'i18n/trains-meta-default';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

export const TrainsOrderMeta: React.FC = () => {
    const location = useLocation();

    const context = useSelector(trainsContextSelector);
    const orderStep = useSelector(orderStepSelector);
    const trainList = useSelector(trainListSelector);

    if (!isFilledTrainsSearchContext(context)) {
        return null;
    }

    const trainTitles = trainList
        .map(trainState => {
            const {trainDetails: trainDetailsInfo, segment} = trainState;

            if (!trainDetailsInfo || !segment) {
                return '';
            }

            return `${getTrainNumber(segment, trainDetailsInfo.trainDetails)} ${
                segment.title
            }`;
        })
        .join(', ');

    const title = i18nBlock.titleDashWithDashServiceDashName({
        title: getTitle({
            trainTitles,
            context,
            orderStep,
        }),
    });
    const url = getAbsoluteUrl(location.pathname, location.search);

    return (
        <>
            <DocumentMeta title={title} />
            <SocialSharingMeta url={url} title={title} />
        </>
    );
};
