import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {IFilledContextPoint} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';

import {HUMAN} from 'utilities/dateUtils/formats';
import {formatDate} from 'utilities/dateUtils';
import humanizePeriod from 'utilities/dateUtils/humanizePeriod';

import * as i18nBlock from 'i18n/trains-meta-order';

interface IGetTitleParams {
    context: ITrainsFilledSearchContext;
    orderStep: ORDER_STEP;
    trainTitles: string;
}

const canInflect = ({
    from,
    to,
}: {
    from: IFilledContextPoint;
    to: IFilledContextPoint;
}): boolean =>
    Boolean(from.titleGenitive && to.titleAccusative && to.preposition);

export default function getTitle(props: IGetTitleParams): string {
    const {orderStep, context, trainTitles} = props;

    if (!trainTitles) {
        return '';
    }

    const {from, to, when, returnWhen} = context;
    const whenFormatted =
        when && returnWhen
            ? humanizePeriod(when, returnWhen, {
                  checkSameDate: false,
                  checkAnotherEndYear: false,
              }).toLowerCase()
            : formatDate(when, HUMAN).toLowerCase();

    const isInflect = canInflect(context);

    const params = {
        fromTitle: from.title,
        fromTitleGenitive: from.titleGenitive || '',
        toTitle: to.title,
        toPreposition: to.preposition || '',
        toTitleAccusative: to.titleAccusative || '',
        title: trainTitles,
        number: '',
        when: whenFormatted,
    };

    switch (orderStep) {
        case ORDER_STEP.PLACES:
            return isInflect
                ? i18nBlock.titleDashPlacesDashHuman(params)
                : i18nBlock.titleDashPlacesDashDash(params);
        case ORDER_STEP.PASSENGERS:
            return isInflect
                ? i18nBlock.titleDashPassengersDashHuman(params)
                : i18nBlock.titleDashPassengersDashDash(params);
        case ORDER_STEP.CONFIRM:
            return isInflect
                ? i18nBlock.titleDashConfirmDashHuman(params)
                : i18nBlock.titleDashConfirmDashDash(params);
        case ORDER_STEP.PAYMENT:
            return isInflect
                ? i18nBlock.titleDashPaymentDashHuman(params)
                : i18nBlock.titleDashPaymentDashDash(params);
    }
}
