import React from 'react';

import {URLs} from 'constants/urls';

import {getAbsoluteUrl} from 'utilities/url';

import * as trainsPopularRoutesKeyset from 'i18n/trains-popular-routes';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

export const TrainsPopularRoutesMeta: React.FC = () => {
    return (
        <>
            <DocumentMeta
                title={trainsPopularRoutesKeyset.metaDashTitle()}
                description={trainsPopularRoutesKeyset.metaDashDescription()}
            />
            <SocialSharingMeta
                url={getAbsoluteUrl(URLs.trainsPopularRoutes)}
                title={trainsPopularRoutesKeyset.metaDashTitle()}
                description={trainsPopularRoutesKeyset.metaDashDescription()}
            />
        </>
    );
};
