import React, {useMemo} from 'react';

import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {IWithClassName} from 'types/withClassName';
import {
    isFilledTrainsSearchContext,
    TrainsSearchContextType,
} from 'reducers/trains/context/types';
import {ICrumb} from 'projects/trains/lib/meta/searchMeta/semanticData/types';
import {ITrainsFilters} from 'types/trains/search/filters/ITrainsFilters';
import {ITrainsSearchSort} from 'projects/trains/lib/sort/types';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import getCrumbs from 'projects/trains/lib/meta/searchMeta/semanticData/getCrumbs';
import {useReachGoal} from 'utilities/metrika/useReachGoal';

import LinkBreadcrumbs from 'components/LinkBreadcrumbs/LinkBreadcrumbs';

import cx from './SearchPageBreadcrumbs.scss';

interface ISearchPageBreadcrumbsProps
    extends IWithClassName,
        IWithQaAttributes {
    context: TrainsSearchContextType;
    sort: ITrainsSearchSort;
    filters?: ITrainsFilters | null;
    nonce: string;
}

const SearchPageBreadcrumbs: React.FC<ISearchPageBreadcrumbsProps> = props => {
    const {className, context, nonce, filters, sort} = props;

    const handleBreadcrumbClick = useReachGoal(ETrainsGoal.BREADCRUMBS_CLICK);

    const crumbs = useMemo<ICrumb[]>(() => {
        if (!isFilledTrainsSearchContext(context)) {
            return [];
        }

        return getCrumbs({
            context,
            filters,
            sort,
        });
    }, [context, filters, sort]);

    if (!crumbs.length || context.returnWhen) {
        return null;
    }

    return (
        <LinkBreadcrumbs
            className={cx('root', className)}
            scrollableClassName={cx('scrollable')}
            nonce={nonce}
            {...prepareQaAttributes(props)}
        >
            {crumbs.map((crumb, index, array) => (
                <LinkBreadcrumbs.Item
                    key={crumb.url}
                    title={crumb.title}
                    metaUrl={crumb.url}
                    onClick={handleBreadcrumbClick}
                    to={index === array.length - 1 ? undefined : crumb.url}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'item',
                        key: index,
                    })}
                >
                    {crumb.name}
                </LinkBreadcrumbs.Item>
            ))}
        </LinkBreadcrumbs>
    );
};

export default SearchPageBreadcrumbs;
