import React from 'react';

import {RZD_DYNAMIC_PRICING_CONDITION_LINK} from 'projects/trains/constants/partnerLinks';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/trainsDisclaimers';
import * as i18nPartnerInfoBlock from 'i18n/trains-train-partner-info';

import Link from 'components/Link/Link';

import cx from './SearchPageFooterDisclaimers.scss';

interface ISearchPageFooterDisclaimersProps
    extends IWithClassName,
        IWithQaAttributes,
        IWithDeviceType {
    hasDynamicPricing: boolean;
    hasCurrencyDisclaimers: boolean;
}

const SearchPageFooterDisclaimers: React.FC<ISearchPageFooterDisclaimersProps> =
    props => {
        const {
            className,
            hasDynamicPricing,
            hasCurrencyDisclaimers,
            deviceType,
        } = props;

        return (
            <div
                className={cx(
                    className,
                    'root',
                    deviceMods('root', deviceType),
                )}
            >
                {hasDynamicPricing && (
                    <div
                        className={cx('disclaimer')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'dynamicPricing',
                        })}
                    >
                        {insertJSXIntoKey(i18nBlock.dynamicPricing)({
                            link: (
                                <Link
                                    key="dynamic-pricing-link"
                                    url={RZD_DYNAMIC_PRICING_CONDITION_LINK}
                                    theme="normal"
                                    target="_blank"
                                    rel="nofollow noopener noreferrer"
                                >
                                    {i18nBlock.dynamicPricingLink()}
                                </Link>
                            ),
                        })}
                    </div>
                )}

                {hasCurrencyDisclaimers && (
                    <div
                        className={cx('disclaimer')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'currencyDisclaimer',
                        })}
                    >
                        {i18nBlock.currencyRuAll()}
                    </div>
                )}

                <div
                    className={cx('disclaimer')}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'partnerInfoDisclaimer',
                    })}
                >
                    {i18nBlock.feeInCost()}{' '}
                    {i18nPartnerInfoBlock.descriptionDashIm()}.
                </div>
            </div>
        );
    };

export default SearchPageFooterDisclaimers;
