import {EFormKey} from 'constants/form/EFormKey';
import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {IFormValidationInfo} from 'types/common/validation/form';
import {EGroupName} from 'types/trains/booking/ITrainsBookFormValues';

import {lastNameValidation} from './validationRules/lastName';
import {firstNameValidation} from './validationRules/firstName';
import {patronymicValidation} from './validationRules/patronymic';
import {sexValidation} from './validationRules/sex';
import {documentNumberValidation} from './validationRules/documentNumber';
import {citizenshipValidation} from './validationRules/citizenship';
import {birthdateValidation} from './validationRules/birthdate';
import {documentDateValidation} from './validationRules/documentDate';
import {bonusCardValidations} from './validationRules/bonusCards';
import {emailValidation} from './validationRules/email';
import {phoneValidation} from './validationRules/phone';
import {additionalContactValidation} from './validationRules/additionalContact';

const PASSENGER_VALIDATIONS = [
    lastNameValidation,
    firstNameValidation,
    patronymicValidation,
    sexValidation,
    birthdateValidation,
    documentNumberValidation,
    citizenshipValidation,
    documentDateValidation,
    ...bonusCardValidations,
];

export const validationInfo: IFormValidationInfo = {
    id: EFormKey.TRAIN_BOOK,
    isStrictStructure: true,
    fieldGroups: [
        {
            id: `${EGroupName.passengers}.${PASSENGERS_TYPES.ADULTS}`,
            fields: [additionalContactValidation, ...PASSENGER_VALIDATIONS],
        },
        {
            id: `${EGroupName.passengers}.${PASSENGERS_TYPES.CHILDREN}`,
            fields: PASSENGER_VALIDATIONS,
        },
        {
            id: `${EGroupName.passengers}.${PASSENGERS_TYPES.BABIES}`,
            fields: PASSENGER_VALIDATIONS,
        },
        {
            id: EGroupName.contacts,
            fields: [emailValidation, phoneValidation],
        },
    ],
};
