import {FREE_PHONE_REGEXP} from 'constants/form/validationRules';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';
import {
    EFieldName,
    EGroupName,
} from 'types/trains/booking/ITrainsBookFormValues';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

import {EMAIL_MASK} from './common';

export const additionalContactValidation: TField = {
    name: EFieldName.additionalContact,
    dependentValidations: [
        /* Если включен чекбокс, то поля должны быть заполнены */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: EGroupName.contacts,
                        fieldName: EFieldName.useOnlyMainContacts,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [false],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.required,
                        params: true,
                        errorMessage: i18nBlock.emptyDashEmailDashOrDashPhone(),
                    },
                    {
                        type: EValidationType.regex,
                        params: `(${FREE_PHONE_REGEXP})|(${EMAIL_MASK})`,
                        errorMessage: i18nBlock.emptyDashEmailDashOrDashPhone(),
                    },
                ],
            },
        },
    ],
};
