import {
    RUSSIAN_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
} from 'constants/document/documentTypes';
import {EFieldName as EPassengerFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';
import {
    EFieldName,
    EGroupName,
} from 'types/trains/booking/ITrainsBookFormValues';

import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

/**
 * Валидация на соответствие типу пассажира (взрослый, ребенок, младенец)
 * находится в projects/trains/components/TrainsOrderPage/PassengersStep/components/PassengerForm/PassengerForm.tsx,
 * т.к. использует значения tariffCategories из ответа ручки.
 */
export const birthdateValidation: TField = {
    name: EPassengerFieldName.birthdate,
    validation: {
        blur: [
            {
                type: EValidationType.validDate,
                params: HUMAN_DATE_RU,
                errorMessage: i18nBlock.isDashInvalidDashDate(),
            },
            {
                type: EValidationType.minDate,
                params: '01.01.1900',
                errorMessage: i18nBlock.tooDashOldDashForDashTrains(),
            },
            {
                type: EValidationType.maxDateFromToday,
                params: {
                    offset: 0,
                    scale: 'day',
                    strict: true,
                },
                errorMessage: i18nBlock.dateDashInDashFuture(),
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                /*
                TODO: elyoskin - Для экспа временно поменяли текст на i18nBlock.emptyDashBirthDashDate(),
                Если эксп не примут, откатить, если примут уточнить про текст
                */
                errorMessage: i18nBlock.isDashInvalidDashDate(),
            },
        ],
    },
    dependentValidations: [
        /* Проверки по типу документа */
        {
            conditions: [
                {
                    path: {fieldName: EPassengerFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.maxDateFromToday,
                        params: {
                            offset: -14,
                            scale: 'year',
                        },
                        errorMessage:
                            i18nBlock.isDashInvalidDashDocumentDashAge(),
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {fieldName: EPassengerFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [MILITARY_CARD],
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.maxDateFromField,
                        params: {
                            offset: -18,
                            scale: 'year',
                            field: {
                                fieldGroupId: EGroupName.trainInfo,
                                fieldName: EFieldName.startDate,
                            },
                        },
                        errorMessage:
                            i18nBlock.isDashInvalidDashDocumentDashAge(),
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {fieldName: EPassengerFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [SAILOR_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.maxDateFromField,
                        params: {
                            offset: -14,
                            scale: 'year',
                            field: {
                                fieldGroupId: EGroupName.trainInfo,
                                fieldName: EFieldName.startDate,
                            },
                        },
                        errorMessage:
                            i18nBlock.isDashInvalidDashDocumentDashAge(),
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {fieldName: EPassengerFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [BIRTH_CERTIFICATE],
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.minDateFromField,
                        params: {
                            offset: -170,
                            scale: 'month',
                            field: {
                                fieldGroupId: EGroupName.trainInfo,
                                fieldName: EFieldName.startDate,
                            },
                        },
                        errorMessage:
                            i18nBlock.isDashInvalidDashDocumentDashAge(),
                    },
                ],
            },
        },
    ],
};
