import {EFieldName as EPassengerFieldName} from 'components/BookingPassengerForm/constants/fieldNames';
import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';
import {EDocumentType} from 'constants/document/documentTypes';

import {TField} from 'types/common/validation/form';
import {EValidationType} from 'types/common/validation/validation';
import {EFieldName} from 'types/trains/booking/ITrainsBookFormValues';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

import {BONUS_CARD_REGEXP} from './common';

const bonusCards = [
    {
        type: TRAIN_BONUS_CARDS.BONUS_CARD,
        errorMessage:
            i18nBlock.incorrectDashRzhdDashBonusDashCardDashNumberDashFormat(),
    },
    {
        type: TRAIN_BONUS_CARDS.ROAD_CARD,
        errorMessage:
            i18nBlock.incorrectDashRzhdDashRoadDashCardDashNumberDashFormat(),
    },
];

/**
 * Валидация на одинаковые бонусные карты раположена здесь:
 * src/projects/trains/components/TrainsOrderPage/PassengersStep/components/PassengerForm/components/AdditionFieldsFooter/components/BonusCards/components/BonusCard/utilities/validateBonusCard.ts
 */
export const bonusCardValidations: TField[] = bonusCards.map(
    ({type, errorMessage}) => ({
        name: `${EFieldName.bonusCards}.${type}`,
        dependentValidations: [
            {
                conditions: [
                    {
                        path: {fieldName: EPassengerFieldName.documentType},
                        value: [
                            {
                                type: EValidationType.notOneOf,
                                params: [EDocumentType.RU_MILITARY_ID],
                            },
                        ],
                    },
                    {
                        path: {
                            fieldName: `${EFieldName.bonusCards}.${type}`,
                        },
                        value: [
                            {
                                type: EValidationType.required,
                                params: true,
                            },
                        ],
                    },
                ],
                validation: {
                    submit: [
                        {
                            type: EValidationType.regex,
                            params: BONUS_CARD_REGEXP,
                            errorMessage,
                        },
                    ],
                },
            },
        ],
    }),
);
