import {
    RUSSIAN_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
} from 'constants/document/documentTypes';
import {RUS, ENG} from 'constants/form/masks';

import {CHAR_DASH, CHAR_EM_DASH} from 'utilities/strings/charCodes';

export const RU_NAMED_DOCUMENTS = [
    RUSSIAN_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
];

export const DASHES = `${CHAR_DASH}${CHAR_EM_DASH}`;

export const WHITE_SPACE = ' ';
export const SEPARATORS = `\\s${DASHES}`;
export const ONLY_WHITE_SPACE = `^(${WHITE_SPACE})+&`;

export const RUS_NAME = `^[${WHITE_SPACE}]*[${RUS}]+([${SEPARATORS}]+[${RUS}]+)*[${WHITE_SPACE}]*$`;
export const ENG_NAME = `^[${WHITE_SPACE}]*[${ENG}]+([${SEPARATORS}]+[${ENG}]+)*[${WHITE_SPACE}]*$`;

export const NAME_MASK = `(${RUS_NAME})|(${ENG_NAME})`;

export const BONUS_CARD_REGEXP = '^\\d{13}$';

// CONTACTS
export const EMAIL_MASK = `^(${WHITE_SPACE})*[\\w+\\-]+([\\w+\\-\\.]+[\\w+\\-]+)*@[\\w+\\-]+\\.[${ENG}]{2,}(${WHITE_SPACE})*$`;
