import {EFieldName as EPassengerFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';
import {
    EFieldName,
    EGroupName,
} from 'types/trains/booking/ITrainsBookFormValues';

import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

export const documentDateValidation: TField = {
    name: EPassengerFieldName.documentValidDate,
    validation: {
        blur: [
            {
                type: EValidationType.validDate,
                params: HUMAN_DATE_RU,
                errorMessage: i18nBlock.isDashInvalidDashDate(),
            },
            {
                type: EValidationType.minDateFromField,
                params: {
                    field: {
                        fieldGroupId: EGroupName.trainInfo,
                        fieldName: EFieldName.endDate,
                    },
                    offset: 0,
                    scale: 'day',
                },
                errorMessage: i18nBlock.documentDashDateDashExpired(),
            },
        ],
    },
};
