import {EFieldName} from 'components/BookingContactsForm/constants/fieldNames';
import {getEmailValidationRegExp} from 'constants/form/validationRules';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

/**
 * Проверка на домен верхнего уровня из фиксированного списка находится в
 * src/projects/trains/components/TrainsOrderPage/PassengersStep/components/ContactsForm/ContactsForm.tsx
 */
export const emailValidation: TField = {
    name: EFieldName.email,
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: 100,
                errorMessage: i18nBlock.longDashEmail(),
            },
            {
                type: EValidationType.regex,
                params: getEmailValidationRegExp({
                    allowRussianCharacters: true,
                }),
                errorMessage: i18nBlock.isDashInvalidDashEmail(),
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.emptyDashEmail(),
            },
        ],
    },
};
