import {RUSSIAN_INTERNATIONAL_PASSPORT} from 'constants/document/documentTypes';
import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

import {RU_NAMED_DOCUMENTS, ENG_NAME, NAME_MASK, RUS_NAME} from './common';

const MAX_LENGTH = 20;

export const firstNameValidation: TField = {
    name: EFieldName.firstName,
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: MAX_LENGTH,
                errorMessage: i18nBlock.isDashLongDashName(),
            },
            {
                type: EValidationType.regex,
                params: '[\\S]+',
                errorMessage: i18nBlock.emptyDashFirstDashName(),
            },
            {
                type: EValidationType.regex,
                params: NAME_MASK,
                errorMessage: i18nBlock.isDashInvalidDashName(),
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.emptyDashFirstDashName(),
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: RU_NAMED_DOCUMENTS,
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.regex,
                        params: RUS_NAME,
                        errorMessage:
                            i18nBlock.isDashInvalidDashLocaleDashFirstDashName(),
                    },
                ],
            },
        },
        /* Если выбран загран, а фамилия и отчество на кириллице */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_INTERNATIONAL_PASSPORT],
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.lastName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: RUS_NAME,
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.patronymicName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: RUS_NAME,
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.regex,
                        params: RUS_NAME,
                        errorMessage: i18nBlock.isDashDifferentDashLocales(),
                    },
                ],
            },
        },
        /* Если выбран загран, а фамилия и отчество на латинице */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_INTERNATIONAL_PASSPORT],
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.lastName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: ENG_NAME,
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.patronymicName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: ENG_NAME,
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.regex,
                        params: ENG_NAME,
                        errorMessage: i18nBlock.isDashDifferentDashLocales(),
                    },
                ],
            },
        },
    ],
};
