import {RUSSIAN_INTERNATIONAL_PASSPORT} from 'constants/document/documentTypes';
import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

import {
    RU_NAMED_DOCUMENTS,
    NAME_MASK,
    RUS_NAME,
    ENG_NAME,
    DASHES,
    WHITE_SPACE,
} from './common';

const WHITE_SPACES = '^( )+$';

const SINGLE_DASH = `^[${WHITE_SPACE}]*[${DASHES}]{1}[${WHITE_SPACE}]*$`;
const NAME_OR_SINGLE_DASH = `${NAME_MASK}|(${SINGLE_DASH})|(${WHITE_SPACES})`;
const RUS_OR_SINGLE_DASH = `(${RUS_NAME})|(${SINGLE_DASH})|(${WHITE_SPACES})`;
const ENG_OR_SINGLE_DASH = `(${ENG_NAME})|(${SINGLE_DASH})|(${WHITE_SPACES})`;

const MAX_LENGTH = 20;

export const patronymicValidation: TField = {
    name: EFieldName.patronymicName,
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: MAX_LENGTH,
                errorMessage: i18nBlock.isDashLongDashName(),
            },
            {
                type: EValidationType.regex,
                params: NAME_OR_SINGLE_DASH,
                errorMessage: i18nBlock.isDashInvalidDashName(),
            },
        ],
    },
    dependentValidations: [
        /* Если не выбран чекбокс отсутствия отчества */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.isPatronymicDisabled},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [false, null, undefined],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.required,
                        params: true,
                        errorMessage:
                            i18nBlock.emptyDashEnabledDashPatronymic(),
                    },
                    {
                        type: EValidationType.regex,
                        params: `${NAME_MASK}|(${SINGLE_DASH})`,
                        errorMessage:
                            i18nBlock.emptyDashEnabledDashPatronymic(),
                    },
                ],
            },
        },
        /* Документы только на кириллице */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: RU_NAMED_DOCUMENTS,
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.regex,
                        params: RUS_OR_SINGLE_DASH,
                        errorMessage:
                            i18nBlock.isDashInvalidDashLocaleDashPatronymic(),
                    },
                ],
            },
        },
        /* Если выбран загран, а имя и фамилия на кириллице */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_INTERNATIONAL_PASSPORT],
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.firstName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: RUS_NAME,
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.lastName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: RUS_NAME,
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.regex,
                        params: RUS_OR_SINGLE_DASH,
                        errorMessage: i18nBlock.isDashDifferentDashLocales(),
                    },
                ],
            },
        },
        /* Если выбран загран, а имя и фамилия на латинице */
        {
            conditions: [
                {
                    path: {fieldName: EFieldName.documentType},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_INTERNATIONAL_PASSPORT],
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.firstName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: ENG_NAME,
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.lastName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: ENG_NAME,
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.regex,
                        params: ENG_OR_SINGLE_DASH,
                        errorMessage: i18nBlock.isDashDifferentDashLocales(),
                    },
                ],
            },
        },
    ],
};
