import {getPhoneValidationRegExp} from 'constants/form/validationRules';
import {EFieldName} from 'components/BookingContactsForm/constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

export const phoneValidation: TField = {
    name: EFieldName.phone,
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: 50,
                errorMessage: i18nBlock.longDashPhoneDashNumber(),
            },
            {
                type: EValidationType.regex,
                params: getPhoneValidationRegExp(11),
                errorMessage:
                    i18nBlock.isDashInvalidDashFreeDashPhoneDashNumber(),
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.emptyDashPhoneDashNumber(),
            },
        ],
    },
};
