import {EFieldName as EPassengerFieldName} from 'components/BookingPassengerForm/constants/fieldNames';
import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';
import {EGender} from 'types/common/document/EGender';
import {
    EFieldName,
    EGroupName,
} from 'types/trains/booking/ITrainsBookFormValues';

import * as i18nBlock from 'i18n/trains-order-fields-errors';

export const sexValidation: TField = {
    name: EPassengerFieldName.sex,
    validation: {
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: i18nBlock.emptyDashGender(),
            },
        ],
    },
    dependentValidations: [
        /* Проверка на купе только для мужчин, включается только для взрослых пассажиров */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: EGroupName.trainInfo,
                        fieldName: EFieldName.coachGender,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [GENDER_TYPE.MALE],
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.ageGroup},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [PASSENGERS_TYPES.ADULTS],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.oneOf,
                        params: [EGender.MALE],
                        errorMessage: i18nBlock.incorrectDashCoachDashGender(),
                    },
                ],
            },
        },
        /* Проверка на купе только для женщин, включается только для взрослых пассажиров */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: EGroupName.trainInfo,
                        fieldName: EFieldName.coachGender,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [GENDER_TYPE.FEMALE],
                        },
                    ],
                },
                {
                    path: {fieldName: EFieldName.ageGroup},
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [PASSENGERS_TYPES.ADULTS],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.oneOf,
                        params: [EGender.FEMALE],
                        errorMessage: i18nBlock.incorrectDashCoachDashGender(),
                    },
                ],
            },
        },
        /* Проверка на мужское отчество */
        {
            conditions: [
                {
                    path: {fieldName: EPassengerFieldName.patronymicName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: '^.*((ич)|(лы))$',
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.oneOf,
                        params: [EGender.MALE],
                        errorMessage:
                            i18nBlock.incorrectDashPatronymicDashGender(),
                    },
                ],
            },
        },
        /* Проверка на женское отчество */
        {
            conditions: [
                {
                    path: {fieldName: EPassengerFieldName.patronymicName},
                    value: [
                        {
                            type: EValidationType.required,
                            params: true,
                        },
                        {
                            type: EValidationType.regex,
                            params: '^.*((на)|(зы))$',
                        },
                    ],
                },
            ],
            validation: {
                blur: [
                    {
                        type: EValidationType.oneOf,
                        params: [EGender.FEMALE],
                        errorMessage:
                            i18nBlock.incorrectDashPatronymicDashGender(),
                    },
                ],
            },
        },
    ],
};
