import {ETrainsCoachType} from 'types/trains/common/tariffs/ETrainsCoachType';

export {ETrainsCoachType as TRAIN_COACH_TYPE};

const TRAIN_COACH_TYPES: ETrainsCoachType[] = [
    ETrainsCoachType.PLATZKARTE,
    ETrainsCoachType.COMPARTMENT,
    ETrainsCoachType.SUITE,
    ETrainsCoachType.COMMON,
    ETrainsCoachType.SITTING,
    ETrainsCoachType.SOFT,
];

export function isTrainsCoachType(
    coachType: any,
): coachType is ETrainsCoachType {
    return TRAIN_COACH_TYPES.includes(coachType);
}

export function isTrainsCoachTypes(
    coachTypes: any,
): coachTypes is ETrainsCoachType[] {
    return coachTypes.every(isTrainsCoachType);
}
