import {EDocumentType} from 'constants/document/documentTypes';

export enum TRAINS_DOCUMENT_TYPES {
    RUSSIAN_PASSPORT = 'ПН',
    BIRTH_CERTIFICATE = 'СР',
    RUSSIAN_INTERNATIONAL_PASSPORT = 'ЗП',
    FOREIGN_DOCUMENT = 'ЗЗ',
    SAILOR_PASSPORT = 'ПМ',
    MILITARY_CARD = 'ВБ',
}

export const MAP_TRAINS_DOCUMENT_TYPES_TO_COMMON = {
    [TRAINS_DOCUMENT_TYPES.RUSSIAN_PASSPORT]:
        EDocumentType.RU_NATIONAL_PASSPORT,
    [TRAINS_DOCUMENT_TYPES.BIRTH_CERTIFICATE]:
        EDocumentType.RU_BIRTH_CERTIFICATE,
    [TRAINS_DOCUMENT_TYPES.RUSSIAN_INTERNATIONAL_PASSPORT]:
        EDocumentType.RU_FOREIGN_PASSPORT,
    [TRAINS_DOCUMENT_TYPES.SAILOR_PASSPORT]: EDocumentType.RU_SEAMAN_PASSPORT,
    [TRAINS_DOCUMENT_TYPES.MILITARY_CARD]: EDocumentType.RU_MILITARY_ID,
    [TRAINS_DOCUMENT_TYPES.FOREIGN_DOCUMENT]: EDocumentType.OTHER,
};

export const MAP_COMMON_DOCUMENT_TYPES_TO_TRAINS = {
    [EDocumentType.RU_NATIONAL_PASSPORT]:
        TRAINS_DOCUMENT_TYPES.RUSSIAN_PASSPORT,
    [EDocumentType.RU_BIRTH_CERTIFICATE]:
        TRAINS_DOCUMENT_TYPES.BIRTH_CERTIFICATE,
    [EDocumentType.RU_FOREIGN_PASSPORT]:
        TRAINS_DOCUMENT_TYPES.RUSSIAN_INTERNATIONAL_PASSPORT,
    [EDocumentType.RU_SEAMAN_PASSPORT]: TRAINS_DOCUMENT_TYPES.SAILOR_PASSPORT,
    [EDocumentType.RU_MILITARY_ID]: TRAINS_DOCUMENT_TYPES.MILITARY_CARD,
    [EDocumentType.OTHER]: TRAINS_DOCUMENT_TYPES.FOREIGN_DOCUMENT,
};
