import {EGender} from 'types/common/document/EGender';

/**
 * Бэкенд никогда не возвращает GENDER_TYPE.SINGLE для поля compartmentGender в заказе.
 * Потому что GENDER_TYPE.SINGLE используется только в одном месте приложения:
 * при выборе мест в купе. Когда купе должно быть определенного гендера, и мы должны выбрать какого.
 */
export enum GENDER_TYPE {
    MIXED = 'mixed',
    MALE = 'male',
    FEMALE = 'female',
    SINGLE = 'single',
}

export const GENDER_TYPES = Object.values(GENDER_TYPE);

export function isGenderType(gender: any): gender is GENDER_TYPE {
    return GENDER_TYPES.includes(gender);
}

export const MALE_AND_FEMALE_GENDER_TYPES: GENDER_TYPE[] = [
    GENDER_TYPE.MALE,
    GENDER_TYPE.FEMALE,
];

export function mapTrainsGenderToCommon(
    gender: GENDER_TYPE | null,
): EGender | undefined {
    if (gender === GENDER_TYPE.MALE) {
        return EGender.MALE;
    } else if (gender === GENDER_TYPE.FEMALE) {
        return EGender.FEMALE;
    }

    return undefined;
}
