import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {ETrainsFilterType} from 'types/trains/search/filters/ITrainsFilters';
import {ERestrictionType} from 'projects/trains/lib/order/fields/restrictions/types';

// trains_order_info_page_loaded
export const E_COMMERCE_TRAINS_PURCHASE_GOAL_ID = 50991667;

export const mapSearchFilterToShowGoal: Record<ETrainsFilterType, ETrainsGoal> =
    {
        [ETrainsFilterType.ARRIVAL]: ETrainsGoal.FILTER_ARRIVAL_SHOW,
        [ETrainsFilterType.DEPARTURE]: ETrainsGoal.FILTER_DEPARTURE_SHOW,
        [ETrainsFilterType.HIGH_SPEED_TRAIN]:
            ETrainsGoal.FILTER_HIGH_SPEED_TRAIN_SHOW,
        [ETrainsFilterType.HIDE_WITHOUT_PRICE]:
            ETrainsGoal.FILTER_HIDE_WITHOUT_PRICE_SHOW,
        [ETrainsFilterType.PRICE_RANGE]: ETrainsGoal.FILTER_PRICE_RANGE_SHOW,
        [ETrainsFilterType.STATION_FROM]: ETrainsGoal.FILTER_STATION_FROM_SHOW,
        [ETrainsFilterType.STATION_TO]: ETrainsGoal.FILTER_STATION_TO_SHOW,
        [ETrainsFilterType.TRAIN_TARIFF_CLASS]:
            ETrainsGoal.FILTER_TRAIN_TARIFF_CLASS_SHOW,
    };

export const mapSearchFilterToClickGoal: Record<
    ETrainsFilterType,
    ETrainsGoal
> = {
    [ETrainsFilterType.ARRIVAL]: ETrainsGoal.FILTER_ARRIVAL_CLICK,
    [ETrainsFilterType.DEPARTURE]: ETrainsGoal.FILTER_DEPARTURE_CLICK,
    [ETrainsFilterType.HIGH_SPEED_TRAIN]:
        ETrainsGoal.FILTER_HIGH_SPEED_TRAIN_CLICK,
    [ETrainsFilterType.HIDE_WITHOUT_PRICE]:
        ETrainsGoal.FILTER_HIDE_WITHOUT_PRICE_CLICK,
    [ETrainsFilterType.PRICE_RANGE]: ETrainsGoal.FILTER_PRICE_RANGE_CLICK,
    [ETrainsFilterType.STATION_FROM]: ETrainsGoal.FILTER_STATION_FROM_CLICK,
    [ETrainsFilterType.STATION_TO]: ETrainsGoal.FILTER_STATION_TO_CLICK,
    [ETrainsFilterType.TRAIN_TARIFF_CLASS]:
        ETrainsGoal.FILTER_TRAIN_TARIFF_CLASS_CLICK,
};

export const mapSearchFastFilterToClickGoal: Record<
    ETrainsFilterType,
    ETrainsGoal
> = {
    [ETrainsFilterType.ARRIVAL]: ETrainsGoal.FAST_FILTER_ARRIVAL_CLICK,
    [ETrainsFilterType.DEPARTURE]: ETrainsGoal.FAST_FILTER_DEPARTURE_CLICK,
    [ETrainsFilterType.HIGH_SPEED_TRAIN]:
        ETrainsGoal.FAST_FILTER_HIGH_SPEED_TRAIN_CLICK,
    [ETrainsFilterType.HIDE_WITHOUT_PRICE]:
        ETrainsGoal.FAST_FILTER_HIDE_WITHOUT_PRICE_CLICK,
    [ETrainsFilterType.PRICE_RANGE]: ETrainsGoal.FAST_FILTER_PRICE_RANGE_CLICK,
    [ETrainsFilterType.STATION_FROM]:
        ETrainsGoal.FAST_FILTER_STATION_FROM_CLICK,
    [ETrainsFilterType.STATION_TO]: ETrainsGoal.FAST_FILTER_STATION_TO_CLICK,
    [ETrainsFilterType.TRAIN_TARIFF_CLASS]:
        ETrainsGoal.FAST_FILTER_TRAIN_TARIFF_CLASS_CLICK,
};

export const mapOrderStepToValidSubmitGoal: Record<ORDER_STEP, ETrainsGoal> = {
    [ORDER_STEP.PLACES]: ETrainsGoal.ORDER_PLACES_SUBMIT,
    [ORDER_STEP.PASSENGERS]: ETrainsGoal.ORDER_PASSENGERS_SUBMIT,
    [ORDER_STEP.CONFIRM]: ETrainsGoal.ORDER_CONFIRM_SUBMIT,
    [ORDER_STEP.PAYMENT]: ETrainsGoal.ORDER_PAYMENT_SUBMIT,
};

export const mapOrderStepToInvalidSubmitGoal: PartialRecord<
    ORDER_STEP,
    ETrainsGoal
> = {
    [ORDER_STEP.PLACES]: ETrainsGoal.ORDER_INVALID_PLACES_SUBMIT,
    [ORDER_STEP.PASSENGERS]: ETrainsGoal.ORDER_INVALID_PASSENGERS_SUBMIT,
};

export const mapRestrictionTypeToGoal: PartialRecord<
    ERestrictionType,
    ETrainsGoal
> = {
    [ERestrictionType.NOT_ENOUGH_PLACES]: ETrainsGoal.NOT_ENOUGH_PLACES,
    [ERestrictionType.NOT_ENOUGH_PLACES_IN_CLASS]:
        ETrainsGoal.NOT_ENOUGH_PLACES_IN_CLASS,
    [ERestrictionType.GENDER_NOT_SELECTED]: ETrainsGoal.GENDER_NOT_SELECTED,
    [ERestrictionType.NO_PASSENGERS_IN_ORDER]:
        ETrainsGoal.NO_PASSENGERS_IN_ORDER,
    [ERestrictionType.NOT_ENOUGH_GENDER_PLACES]:
        ETrainsGoal.NOT_ENOUGH_GENDER_PLACES,
    [ERestrictionType.SERVICE_CLASS_NOT_SELECTED]:
        ETrainsGoal.SERVICE_CLASS_NOT_SELECTED,
    [ERestrictionType.MORE_PASSENGERS_THAN_PLACES]:
        ETrainsGoal.MORE_PASSENGERS_THAN_PLACES,
    [ERestrictionType.LESS_PASSENGERS_THAN_PLACES]:
        ETrainsGoal.LESS_PASSENGERS_THAN_PLACES,
    [ERestrictionType.MORE_THAN_ONE_DISCOUNT_TICKET_PER_PERSON]:
        ETrainsGoal.MORE_THAN_ONE_DISCOUNT_TICKET_PER_PERSON,
    [ERestrictionType.MORE_THAN_ONE_TICKET_PER_PERSON]:
        ETrainsGoal.MORE_THAN_ONE_TICKET_PER_PERSON,
    [ERestrictionType.MAX_PASSENGERS_REACHED]:
        ETrainsGoal.MAX_PASSENGERS_REACHED,
    [ERestrictionType.ONLY_ONE_CHILDREN_IN_TWO_SEATER_COMPARTMENT]:
        ETrainsGoal.ONLY_ONE_CHILDREN_IN_TWO_SEATER_COMPARTMENT,
    [ERestrictionType.ONLY_CHILDREN_IN_MEETING_ROOM_COMPARTMENT]:
        ETrainsGoal.ONLY_CHILDREN_IN_MEETING_ROOM_COMPARTMENT,
};
