import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

// Константа для общих случаев (например, для этажа или для мест для сапсана)
export const REQUIREMENTS_IRRELEVANT_OPTION = 'irrelevant';

export enum ARRANGEMENT_REQUIREMENTS {
    COMPARTMENT = 'compartment',
    NEAREST = 'nearest',
    SECTION = 'section',
    NOT_SIDE = 'notSide',
    IRRELEVANT = 'irrelevant',
}

export enum ADDITIONAL_REQUIREMENTS {
    FORWARD = 'Forward',
    NEAR_WINDOW = 'NearWindow',
    NEAR_TABLE_AND_FORWARD = 'NearTheTableAndForward',
    NEAR_TABLE = 'AnyNearTheTable',
    NO_TABLE = 'AnyNotNearTheTable',
    NO_TABLE_AND_FORWARD = 'WithoutTableAndForward',
    SINGLE_AND_FORWARD = 'SingleAndForward',
    WITH_PETS = 'WithPetsPlaces',

    // Не используется фронтендом
    NO_VALUE = 'NoValue',
    MOTHER_AND_BABY_PLACES = 'MotherAndBabyPlaces',
    WITH_BABY_PLACES = 'WithBabyPlaces',
    USUAL = 'Usual',
    USUAL_NEAR_THE_TABLE = 'UsualNearTheTable',
    NEAR_THE_PLAYGROUND = 'NearThePlayground',
    NEAR_THE_PLAYGROUND_AND_NOT_THE_TABLE = 'NearThePlaygroundAndNotTheTable',
    NEAR_THE_PLAYGROUND_AND_THE_TABLE = 'NearThePlaygroundAndTheTable',
    NEAR_THE_PLACES_WITH_PETS = 'NearThePlacesWithPets',
    FOLDABLE_PLACE = 'FoldablePlace',
    BACKWARD = 'Backward',
    UNFOLDABLE_PLACE = 'UnfoldablePlace',
    NEAR_THE_TABLE_AND_BACKWARD = 'NearTheTableAndBackward',
    WITHOUT_TABLE_AND_BACKWARD = 'WithoutTableAndBackward',
    WITHOUT_WINDOW_AND_BACKWARD = 'WithoutWindowAndBackward',
    WITHOUT_WINDOW_AND_FORWARD = 'WithoutWindowAndForward',
    NEAR_RESTROOM = 'NearRestroom',
    NEAR_RESTROOM_AND_BACKWARD = 'NearRestroomAndBackward',
    NEAR_RESTROOM_AND_FORWARD = 'NearRestroomAndForward',
    NO_TABLE_AND_NO_WINDOW = 'NoTableAndNoWindow',
}

export const COACH_TYPE_WITH_REQUIREMENTS = [
    TRAIN_COACH_TYPE.PLATZKARTE,
    TRAIN_COACH_TYPE.COMPARTMENT,
    TRAIN_COACH_TYPE.SITTING,
];

export const MAX_PLACE_TYPE_COUNT_PER_PLATZKARTE_SECTION = 3;
export const MAX_PLACE_TYPE_COUNT_PER_PLATZKARTE_COMPARTMENT = 2;

// Ограничение не задано для купе, т.к. они могут иметь разную вместимость (2, 4 человека)
export const MAX_PLACE_TYPE_COUNT = {
    [TRAIN_COACH_TYPE.PLATZKARTE]: {
        [ARRANGEMENT_REQUIREMENTS.COMPARTMENT]:
            MAX_PLACE_TYPE_COUNT_PER_PLATZKARTE_COMPARTMENT,
        [ARRANGEMENT_REQUIREMENTS.SECTION]:
            MAX_PLACE_TYPE_COUNT_PER_PLATZKARTE_SECTION,
        [ARRANGEMENT_REQUIREMENTS.IRRELEVANT]: null,
        [ARRANGEMENT_REQUIREMENTS.NEAREST]: null,
        [ARRANGEMENT_REQUIREMENTS.NOT_SIDE]: null,
    },
    [TRAIN_COACH_TYPE.SITTING]: null,
    [TRAIN_COACH_TYPE.COMPARTMENT]: null,
    [TRAIN_COACH_TYPE.SOFT]: null,
    [TRAIN_COACH_TYPE.COMMON]: null,
    [TRAIN_COACH_TYPE.SUITE]: null,
};
