import IGenericOrderGetOrderApiResponse from 'server/api/GenericOrderApi/types/getOrder/IGenericOrderGetOrderApiResponse';
import IGenericOrderGetOrderStateApiResponse from 'server/api/GenericOrderApi/types/getOrderState/IGenericOrderGetOrderStateApiResponse';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

import {genericOrderBrowserProvider} from 'serviceProvider/genericOrder/genericOrderBrowserProvider';

export default function createLatestOrderInfoFetcher() {
    let currentGenericOrderState:
        | IGenericOrderGetOrderStateApiResponse
        | undefined;
    let currentGenericOrder: IGenericOrderGetOrderApiResponse | undefined;

    return async (orderId: string): Promise<IGenericOrderInfo> => {
        const genericOrderState =
            await genericOrderBrowserProvider.getOrderState({
                orderId,
            });

        if (
            currentGenericOrderState?.versionHash !==
                genericOrderState.versionHash ||
            currentGenericOrderState?.state !== genericOrderState.state ||
            !currentGenericOrder
        ) {
            currentGenericOrder = await genericOrderBrowserProvider.getOrder({
                orderId,
            });
        }

        currentGenericOrderState = genericOrderState;

        return currentGenericOrder;
    };
}
