import {
    IStoreTrainTraveler,
    ITrainOrderContacts,
} from 'reducers/trains/order/types';
import IGenericOrderGetOrderStateApiResponse from 'server/api/GenericOrderApi/types/getOrderState/IGenericOrderGetOrderStateApiResponse';
import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

import {StoredTrainAction} from 'reducers/trains/trainsReducerTypes';
import {IOfferWithDirectionAndIndex} from 'reducers/trains/order/thunk/saveOffers';

import {TPassengersForOrder} from 'selectors/trains/order/passengersForOrderSelector';

import {delay} from 'utilities/async/delay';
import prepareCreateGenericOrderParams from 'projects/trains/lib/api/utilities/prepareCreateGenericOrderParams/prepareCreateGenericOrderParams';

import {genericOrderBrowserProvider} from 'serviceProvider/genericOrder/genericOrderBrowserProvider';

export async function createNewOrder({
    offers,
    userActions,
    passengersData,
    contacts,
    traveler,
}: {
    offers: IOfferWithDirectionAndIndex[];
    userActions: StoredTrainAction[];
    passengersData: TPassengersForOrder;
    contacts: ITrainOrderContacts;
    traveler: IStoreTrainTraveler;
}): Promise<IGenericOrderInfo> {
    const createGenericOrderParams = prepareCreateGenericOrderParams({
        offers,
        passengersData,
        contacts,
        traveler,
        orderHistory: userActions,
    });
    const {id} = await genericOrderBrowserProvider.createOrder(
        createGenericOrderParams,
    );

    let orderState: IGenericOrderGetOrderStateApiResponse;

    do {
        await delay(1000);

        orderState = await genericOrderBrowserProvider.getOrderState({
            orderId: id,
        });
    } while (
        orderState.state !== EGenericOrderState.RESERVED &&
        orderState.state !== EGenericOrderState.CANCELLED
    );

    return genericOrderBrowserProvider.getOrder({orderId: id});
}
