import countBy from 'lodash/countBy';

import {LANG} from 'constants/langCodes';

import {Request} from '@yandex-data-ui/core/lib/types';
import {ESearchFormFieldName} from 'components/SearchForm/types';
import {
    ETrainsSuggestType,
    ITrainsSuggest,
} from 'types/trains/common/ITrainsApiSuggest';

import {trains as trainsProvider} from 'serviceProvider/trains/trains';

export default async function requestSearchSuggests({
    req,
    fieldName,
    part,
    clientCity,
    otherPoint,
}: {
    req?: Request;
    fieldName: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
    part: string;
    clientCity: string;
    otherPoint: string;
}): Promise<ITrainsSuggest[]> {
    const {items} = await trainsProvider.provider(req?.container).getSuggests({
        format: 'new',
        lang: LANG.RU,
        national_version: LANG.RU,
        t_type_code: 'train',
        field: fieldName,
        part,
        client_city: clientCity,
        other_point: otherPoint,
    });

    const pointsHashMap = countBy(items, ({title}) => title);

    return items
        .map(item => ({
            objType: item.objType,
            country: item.country,
            fullTitle: item.full_title,
            pointKey: item.point_key,
            popularTitle: item.popular_title,
            region: item.region,
            settlement: item.settlement,
            slug: item.slug,
            stationType: item.station_type,
            title: item.title,
            objId:
                (item.objType === ETrainsSuggestType.SETTLEMENT ? 'c' : 's') +
                item.objId,
            isUniqueTitle: pointsHashMap[item.title] === 1,
        }))
        .slice(0, 5);
}
