import EGenericOrderState from 'server/api/GenericOrderApi/types/common/EGenericOrderState';

import normalizeGenericOrderState from 'projects/trains/lib/api/utilities/normalizeGenericOrderState';

const FINAL_STATES = [
    EGenericOrderState.CONFIRMED,
    EGenericOrderState.CANCELLED,
    EGenericOrderState.REFUNDED,
];

/**
 * Проверяет статус на конечное состояние
 */
export default function isFinalGenericOrderState(
    state: EGenericOrderState | string,
): boolean {
    return FINAL_STATES.includes(normalizeGenericOrderState(state));
}
