import EGenericOrderState, {
    isGenericOrderState,
} from 'server/api/GenericOrderApi/types/common/EGenericOrderState';

/**
 * Функция нормализует ответ от бека, который может присылать неизвестные нам статусы по правилу:
 * Все неизвестные считаем как IN_PROGRESS
 */
export default function normalizeGenericOrderState(
    state: EGenericOrderState | string | undefined,
): EGenericOrderState {
    if (!state || !isGenericOrderState(state)) {
        return EGenericOrderState.IN_PROGRESS;
    }

    return state;
}
