import {v4 as uuid} from 'uuid';

import IGenericOrderCreateOrderServiceParams from 'server/services/GenericOrderService/types/createOrder/IGenericOrderCreateOrderServiceParams';
import {
    IStoreTrainTraveler,
    ITrainOrderContacts,
} from 'reducers/trains/order/types';

import {IOfferWithDirectionAndIndex} from 'reducers/trains/order/thunk/saveOffers';
import {StoredTrainAction} from 'reducers/trains/trainsReducerTypes';

import {TPassengersForOrder} from 'selectors/trains/order/passengersForOrderSelector';

import prepareCreateOrderPassengers from 'projects/trains/lib/api/utilities/prepareCreateOrderParams/utilities/prepareCreateOrderPassengers/prepareCreateOrderPassengers';
import {getTrainsTestContextTokens} from 'projects/trains/lib/urls/getTrainsTestContextTokens';
import {getPaymentTestContextToken} from 'utilities/url/getPaymentTestContextToken';

interface IParams {
    offers: IOfferWithDirectionAndIndex[];
    passengersData: TPassengersForOrder;
    traveler: IStoreTrainTraveler;
    contacts: ITrainOrderContacts;
    orderHistory: StoredTrainAction[];
}

export default function prepareCreateGenericOrderParams(
    params: IParams,
): IGenericOrderCreateOrderServiceParams {
    const {offers, passengersData, traveler, contacts, orderHistory} = params;
    const trainTestContextTokens = getTrainsTestContextTokens();
    const label = offers[0].offer.labelHash;
    const correlationId = uuid();

    return {
        deduplicationKey: uuid(),
        label,
        orderHistory,
        contactInfo: {
            phone: contacts.phone.value || '',
            email: contacts.email.value ?? '',
        },
        hotelServices: [],
        trainServices: offers.map(({offer, direction, index}, i) => {
            const passengers = prepareCreateOrderPassengers({
                passengersData: passengersData[direction][index],
                contacts,
                traveler,
            });
            const trainTestContextToken =
                trainTestContextTokens[i] ?? trainTestContextTokens[0];

            return {
                offerId: offer.offerId,
                passengers,
                trainTestContextToken,
                correlationId,
            };
        }),
        paymentTestContextToken: getPaymentTestContextToken(),
    };
}
