import _cloneDeep from 'lodash/cloneDeep';

import {ITrainPassenger} from 'reducers/trains/order/types';
import {TPlaces} from 'projects/trains/lib/order/getTrainPriceDetails/types/ITrainPriceDetails';

type TPassengerPlacesMap = number[][];

export default function createPassengerPlacesMapByIndex({
    passengersData,
    priceDetailsPlaces,
    isPlacesSelectedAtOnce,
}: {
    passengersData: ITrainPassenger[];
    priceDetailsPlaces?: TPlaces;
    isPlacesSelectedAtOnce?: boolean;
}): TPassengerPlacesMap {
    if (!priceDetailsPlaces || isPlacesSelectedAtOnce) {
        return [];
    }

    const clonedPriceDetailsPlaces = _cloneDeep(priceDetailsPlaces);

    return passengersData.map(passenger => {
        const ageGroupPlaces = clonedPriceDetailsPlaces?.[passenger.ageGroup];

        return ageGroupPlaces?.shift()?.numbers || [];
    });
}
