import isEmpty from 'lodash/isEmpty';

import {ITrainsRequirements} from 'reducers/trains/order/types';

/**
 * Возвращает набор требований, обновленный флагами из схемы вагона и выбранных мест
 */
export default function patchRequirements({
    requirements,
    orderPlaces,
    upper,
    middle,
}: {
    requirements: ITrainsRequirements;
    orderPlaces: number[];
    upper: number[];
    middle: number[];
}): ITrainsRequirements {
    if (!isEmpty(requirements)) {
        return requirements;
    }

    if (upper.length) {
        const upperPlacesCount = orderPlaces.filter(number =>
            upper.includes(number),
        ).length;
        const middlePlacesCount = orderPlaces.filter(number =>
            middle.includes(number),
        ).length;

        return {
            count: {
                upper: upperPlacesCount,
                bottom:
                    orderPlaces.length - upperPlacesCount - middlePlacesCount,
            },
        };
    }

    return requirements;
}
