import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';

import {PassengerBonusCardsType} from 'reducers/trains/order/types';
import ITrainsCreateOrderLoyaltyCard from 'server/api/TrainsBookingApi/types/ITrainsCreateOrderLoyaltyCard';

export default function prepareLoyaltyCards(
    passengerBonusCards: PassengerBonusCardsType,
): ITrainsCreateOrderLoyaltyCard[] {
    return Object.entries(passengerBonusCards).reduce<
        ITrainsCreateOrderLoyaltyCard[]
    >((cards, [type, number]) => {
        if (number?.value) {
            cards.push({
                type: type as TRAIN_BONUS_CARDS,
                number: number.value,
            });
        }

        return cards;
    }, []);
}
