import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainPassenger, ITrainsCoach} from 'reducers/trains/order/types';
import ITrainsSaveOfferPassenger from 'server/api/TrainsOfferStorageApi/types/ITrainsSaveOfferPassenger';
import {IStation} from 'projects/trains/lib/segments/types';
import {TPlaces} from 'projects/trains/lib/order/getTrainPriceDetails/types/ITrainPriceDetails';

import {getPassengersTariffs} from 'projects/trains/lib/order/tariffsInfo';

import prepareLoyaltyCards from './prepareLoyaltyCards';
import createPassengerPlacesMapByIndex from './createPassengerPlacesMapByIndex';

export interface IPrepareSaveOfferPassengersParams {
    passengersData: ITrainPassenger[];
    departure: string;
    stationFrom: IStation;
    coach: ITrainsCoach;
    priceDetailsPlaces?: TPlaces;
    isPlacesSelectedAtOnce?: boolean;
}

export default function prepareSaveOfferPassengers(
    params: IPrepareSaveOfferPassengersParams,
): ITrainsSaveOfferPassenger[] {
    const {
        passengersData,
        departure,
        coach,
        priceDetailsPlaces,
        isPlacesSelectedAtOnce,
    } = params;
    const passengersTariffs = getPassengersTariffs({
        passengers: passengersData,
        departure,
        tariffs: coach.tariffsInfo,
    });
    const passengerPlacesMapByIndex = createPassengerPlacesMapByIndex({
        passengersData,
        priceDetailsPlaces,
        isPlacesSelectedAtOnce,
    });

    return passengersData.map(
        (
            passenger: ITrainPassenger,
            passengerIndex: number,
        ): ITrainsSaveOfferPassenger => {
            const tariffInfo = passengersTariffs[passengerIndex];
            const documentType = passenger.passengerDocument.type.value;
            const loyaltyCards = prepareLoyaltyCards(passenger.bonusCards);
            const passengerPlaces = passengerPlacesMapByIndex[passengerIndex];

            if (!documentType) {
                throw new Error('documentType is not selected');
            }

            return {
                index: passengerIndex,
                sex: passenger.gender.value === GENDER_TYPE.MALE ? 'M' : 'F',
                docType: documentType,
                citizenshipGeoId: passenger.passengerDocument.country
                    .value as number,
                loyaltyCards,
                tariff: tariffInfo?.code ?? null,
                ageGroup: passenger.ageGroup,
                isNonRefundableTariff: passenger.isNonRefundableTariff,
                places: passengerPlaces,
            };
        },
    );
}
