const MAP_TYPES = {
    number: Map,
    string: Map,
    boolean: Map,
    object: WeakMap,
    function: WeakMap,
    undefined: Map,
};

class WeakCacheNode {
    maps: any;
    result: any;

    constructor() {
        this.maps = {};
    }

    _getType(key: any) {
        if (key === null) {
            return 'undefined';
        }

        return typeof key;
    }

    _getMap(keyType: any) {
        return this.maps[keyType];
    }

    _createMap(keyType: any) {
        // @ts-ignore
        this.maps[keyType] = new MAP_TYPES[keyType]();

        return this.maps[keyType];
    }

    _getOrCreateMap(keyType: any) {
        return this._getMap(keyType) || this._createMap(keyType);
    }

    set(key: any, value: any) {
        const keyType = this._getType(key);
        const map = this._getOrCreateMap(keyType);

        map.set(key, value);

        return this;
    }

    get(key: any) {
        const keyType = this._getType(key);
        const map = this._getMap(keyType);

        return map && map.get(key);
    }

    setResult(result: any) {
        this.result = result;

        return this;
    }

    getResult() {
        return this.result;
    }
}

class WeakCache {
    root: WeakCacheNode;

    constructor() {
        this.root = new WeakCacheNode();
    }

    set(args: any[], result: any) {
        let item = this.root;
        let i = 0;
        const l = args.length;

        for (; i < l; i++) {
            const arg = args[i];
            let next = item.get(arg);

            if (!next) {
                next = new WeakCacheNode();
                item.set(arg, next);
            }

            item = next;
        }

        item.setResult(result);

        return this;
    }

    get(args: any[]) {
        let item = this.root;
        const l = args.length;

        for (let i = 0; i < l; i++) {
            item = item.get(args[i]);

            if (!item) {
                return;
            }
        }

        return item.getResult();
    }
}

export function makeCacheable<F extends Function>(func: F): F {
    const cache = new WeakCache();

    // @ts-ignore
    return function (...args) {
        let result = cache.get(args);

        if (result === undefined) {
            result = func(...args);
            cache.set(args, result);
        }

        return result;
    };
}

export const joinArrays = makeCacheable((...arrays: any[]) =>
    [].concat(...arrays),
);
