import {EDirection} from 'types/common/EDirection';

interface IDirectionAndIndex {
    direction: EDirection;
    index: number;
}

/**
 * Сравнивает два направления+индекс
 * @param a
 * @param b
 * @return число
 * отрицательное - a меньше b
 * ноль - a равно b
 * положительное - a больше b
 */
export default function compareDirectionAndIndex(
    a: IDirectionAndIndex,
    b: IDirectionAndIndex,
): number {
    if (a.direction === b.direction) {
        return a.index - b.index;
    }

    if (a.direction === EDirection.FORWARD) {
        return -1;
    }

    return 1;
}
