import {ITrainGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';
import {EDirection} from 'types/common/EDirection';

import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';

export default function findTrainService(
    orderInfo: IGenericOrderInfo | null,
    direction: EDirection,
    index: number,
): ITrainGenericService | undefined {
    if (!orderInfo) {
        return undefined;
    }

    return getTrainServices(orderInfo).find(
        ({trainInfo}) =>
            trainInfo.segmentIndex === index &&
            trainInfo.direction === direction,
    );
}
