import {flatMap} from 'lodash';

import {EDirection} from 'types/common/EDirection';
import {ITrainOrderState, TTrainsOrderState} from 'reducers/trains/order/types';

import mapTrainsState from 'projects/trains/lib/complexOrder/mapTrainsState';

export type TMapTrainsState<T> = Record<EDirection, Record<number, T>>;

/**
 * Мапит поезда в данные,но при этом возвращает результат списком
 * логика маппинга передается через callback
 * @param trains
 * @param callback
 */
export default function mapTrainList<T>(
    trains: TTrainsOrderState,
    callback: (
        train: ITrainOrderState,
        direction: EDirection,
        index: number,
    ) => T,
): T[] {
    const mappedState = mapTrainsState(trains, callback);

    return flatMap(Object.values(mappedState), directionTrains =>
        Object.values(directionTrains),
    );
}
