import {mapValues} from 'lodash';

import {EDirection, isEDirection} from 'types/common/EDirection';
import {ITrainOrderState, TTrainsOrderState} from 'reducers/trains/order/types';

export type TMapTrainsState<T> = Record<EDirection, Record<number, T>>;

/**
 * Мапит поезда в данные,
 * логика маппинга передается через callback
 * @param trains
 * @param callback
 */
export default function mapTrainsState<T>(
    trains: TTrainsOrderState,
    callback: (
        train: ITrainOrderState,
        direction: EDirection,
        index: number,
    ) => T,
): TMapTrainsState<T> {
    return mapValues(trains, (directionTrains, direction) => {
        if (!isEDirection(direction)) {
            return [];
        }

        return mapValues(directionTrains, (train, index) => {
            return callback(train, direction, Number(index));
        });
    });
}
