import {isFilledContextPoint} from 'reducers/trains/context/types';
import {ITrainsCanonicalResponse} from 'server/api/TrainsSearchApi/types/ITrainsCanonical';
import {IRaspParseContextApiResponse} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';

export function canonicalizeContext(
    context: IRaspParseContextApiResponse,
    canonical: Nullable<ITrainsCanonicalResponse>,
): IRaspParseContextApiResponse {
    if (!canonical) {
        return context;
    }

    const needUpdateFrom =
        isFilledContextPoint(context.from) &&
        context.from.slug !== canonical.fromSlug;
    const needUpdateTo =
        isFilledContextPoint(context.to) &&
        context.to.slug !== canonical.toSlug;

    if (!needUpdateFrom && !needUpdateTo) {
        return context;
    }

    const contextToUpdate = {
        ...context,
        from: {...context.from},
        to: {...context.to},
    };
    const {from, to} = contextToUpdate;

    if (isFilledContextPoint(from) && from.slug !== canonical.fromSlug) {
        from.slug = canonical.fromSlug;
        from.title = canonical.fromTitle;
        from.popularTitle = canonical.fromPopularTitle;
    }

    if (isFilledContextPoint(to) && to.slug !== canonical.toSlug) {
        to.slug = canonical.toSlug;
        to.title = canonical.toTitle;
        to.popularTitle = canonical.toPopularTitle;
    }

    return contextToUpdate;
}
